import java.util.Arrays;
import java.util.LinkedList;
import java.util.Scanner;


public class Main {

	/**
	 * @param args
	 */
	static boolean[] used = new boolean[20000];
	static int[] curweight = new int[20000];
	static LinkedList[] ways = new LinkedList[20000];
	static Backtrack[] from_a = new Backtrack[20000];
	
	static class IntPair {
		public int path;
		public int weight;
		public int index;
		public IntPair(int path, int weight, int index) {
			this.path = path;
			this.weight = weight;
			this.index = index;
		}
	}
	
	static class Backtrack {
		public int from;
		public int index;
		public Backtrack(int from, int index) {
			this.from = from;
			this.index = index;
		}
	}
	
	static int n, m;
	
	static void find(int from, int excl) {
		for (Object v : ways[from]) {
			if (((IntPair)v).index == excl) continue;
			int i = ((IntPair)v).path;
			if (curweight[from] + ((IntPair)v).weight < curweight[i]) {
				curweight[i] =curweight[from] + ((IntPair)v).weight;
				from_a[i] = new Backtrack(from, ((IntPair)v).index);
			}
			
		}
		used[from] = true;
		for (int i=0; i<n; ++i) {
			if (!used[i]) find(i, excl);
		}
	}
	
	public static void main(String[] args) {
		Scanner in = new Scanner(System.in);
		
		for (int i=0;i<20000;++i) ways[i] = new LinkedList();
		n = in.nextInt();
		m = in.nextInt();
		for (int i=0;i<m;++i) {
			int from = in.nextInt();
			int to = in.nextInt();
			ways[from-1].add(new IntPair(to-1, in.nextInt(), i));
		}
		Arrays.fill(used, false);
		Arrays.fill(curweight, Integer.MAX_VALUE);
		curweight[0]=0;
		find(0, -1);
		int minw = curweight[n-1];
		
		LinkedList exclroads = new LinkedList();
		int ix = n-1;
		while (ix != 0) {
			exclroads.add(Integer.valueOf(from_a[ix].index));
			ix = from_a[ix].from;
		}
		
		LinkedList important = new LinkedList();
		for (Object obj : exclroads) {
			int i = ((Integer)obj).intValue();
			Arrays.fill(used, false);
			Arrays.fill(curweight, Integer.MAX_VALUE);
			curweight[0]=0;
			find(0, i);
			if (curweight[n-1] > minw) important.add(Integer.valueOf(i+1));
		}
		
		System.out.println(important.size());
		for (Object i : important) {
			System.out.print(i);
			System.out.print(" ");
		}
		System.out.println();
	}

}
